﻿// Copyright (c) .NET Foundation and Contributors. Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System;
using System.Collections.Generic;

namespace Roslynator.Collections;

internal class ReadOnlyCollection<T> : Enumerable<T>, ICollection<T>
{
    public static readonly ICollection<T> Instance = new ReadOnlyCollection<T>();

    protected ReadOnlyCollection()
    {
    }

    public void Add(T item)
    {
        throw new NotSupportedException();
    }

    public void Clear()
    {
        throw new NotSupportedException();
    }

    public bool Contains(T item)
    {
        return false;
    }

    public void CopyTo(T[] array, int arrayIndex)
    {
    }

    public int Count
    {
        get { return 0; }
    }

    public bool IsReadOnly
    {
        get { return true; }
    }

    public bool Remove(T item)
    {
        throw new NotSupportedException();
    }
}
